/*
 * Decompiled with CFR 0.152.
 */
package net.hecco.bountifulfares;

import com.google.gson.GsonBuilder;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import net.fabricmc.loader.api.FabricLoader;
import net.hecco.bountifulfares.BountifulFares;

public class BountifulFaresConfiguration {
    private static final File CONFIG_FILE = new File(FabricLoader.getInstance().getConfigDir().toFile(), "bountifulfares.json");
    private boolean fruitReplaceWhenPicked = true;
    private boolean enableLapisberrySeeds = true;
    private boolean enableHoarySeeds = true;
    private boolean enableElderGuardianSpongekinSeeds = true;
    private boolean enableGuardianSpongekinSeeds = true;
    private boolean enableBountifulPainting = true;
    private boolean enableCitrusDishPainting = true;
    private boolean enableHazelFloretPainting = true;
    private boolean enableVioletFloretPainting = true;
    private boolean enableWhyBluePainting = true;
    private boolean enableRuminerPainting = true;
    private boolean enablePhylogenesisPainting = true;
    private boolean enableEscaladePainting = true;
    private boolean enableAquaculturePainting = true;
    private boolean enableUnpleasantTilesPainting = true;
    private boolean generateWildWheat = true;
    private boolean generateWildCarrots = true;
    private boolean generateWildPotatoes = true;
    private boolean generateWildBeetroot = true;
    private boolean generateAppleTrees = true;
    private boolean generateOrangeTrees = true;
    private boolean generateLemonTrees = true;
    private boolean generatePlumTrees = true;
    private boolean generateAllFruitTreesInFlowerForest = false;
    private boolean generateForestTeaShrubs = false;
    private boolean generateForestWalnutTrees = false;
    private int fermentationTime = 300;
    private int millingTime = 4;
    private boolean honeysuckleToBananaDye = true;
    private boolean renameItemsToMatchDyes = true;
    private boolean honeysuckleToAmberDye = true;
    private boolean chamomileToBeigeDye = true;

    public static BountifulFaresConfiguration load() {
        BountifulFaresConfiguration configuration = new BountifulFaresConfiguration();
        if (!CONFIG_FILE.exists()) {
            BountifulFaresConfiguration.save(configuration);
        }
        try {
            BufferedReader reader = Files.newBufferedReader(CONFIG_FILE.toPath());
            configuration = (BountifulFaresConfiguration)new GsonBuilder().setPrettyPrinting().create().fromJson((Reader)reader, BountifulFaresConfiguration.class);
            ((Reader)reader).close();
        }
        catch (IOException e) {
            BountifulFares.LOGGER.error("Error while trying to load configuration file. Default configuration used.", (Throwable)e);
        }
        return configuration;
    }

    public static void save(BountifulFaresConfiguration config) {
        try {
            BufferedWriter writer = Files.newBufferedWriter(CONFIG_FILE.toPath(), new OpenOption[0]);
            new GsonBuilder().setPrettyPrinting().create().toJson((Object)config, (Appendable)writer);
            ((Writer)writer).close();
        }
        catch (IOException e) {
            BountifulFares.LOGGER.error("Error while trying to save configuration file.", (Throwable)e);
        }
    }

    public boolean isFruitReplaceWhenPicked() {
        return this.fruitReplaceWhenPicked;
    }

    public void setFruitReplaceWhenPicked(boolean bool) {
        this.fruitReplaceWhenPicked = bool;
    }

    public boolean isEnableLapisberrySeeds() {
        return this.enableLapisberrySeeds;
    }

    public void setEnableLapisberrySeeds(boolean bool) {
        this.enableLapisberrySeeds = bool;
    }

    public boolean isEnableHoarySeeds() {
        return this.enableHoarySeeds;
    }

    public void setEnableHoarySeeds(boolean bool) {
        this.enableHoarySeeds = bool;
    }

    public boolean isEnableElderGuardianSpongekinSeeds() {
        return this.enableElderGuardianSpongekinSeeds;
    }

    public void setEnableElderGuardianSpongekinSeeds(boolean bool) {
        this.enableElderGuardianSpongekinSeeds = bool;
    }

    public boolean isEnableGuardianSpongekinSeeds() {
        return this.enableGuardianSpongekinSeeds;
    }

    public void setEnableGuardianSpongekinSeeds(boolean bool) {
        this.enableGuardianSpongekinSeeds = bool;
    }

    public boolean isEnableBountifulPainting() {
        return this.enableBountifulPainting;
    }

    public void setEnableBountifulPainting(boolean bool) {
        this.enableBountifulPainting = bool;
    }

    public boolean isEnableCitrusDishPainting() {
        return this.enableCitrusDishPainting;
    }

    public void setEnableCitrusDishPainting(boolean bool) {
        this.enableCitrusDishPainting = bool;
    }

    public boolean isEnableHazelFloretPainting() {
        return this.enableHazelFloretPainting;
    }

    public void setEnableHazelFloretPainting(boolean bool) {
        this.enableHazelFloretPainting = bool;
    }

    public boolean isEnableVioletFloretPainting() {
        return this.enableVioletFloretPainting;
    }

    public void setEnableVioletFloretPainting(boolean bool) {
        this.enableVioletFloretPainting = bool;
    }

    public boolean isEnableWhyBluePainting() {
        return this.enableWhyBluePainting;
    }

    public void setEnableWhyBluePainting(boolean bool) {
        this.enableWhyBluePainting = bool;
    }

    public boolean isEnableRuminerPainting() {
        return this.enableRuminerPainting;
    }

    public void setEnableRuminerPainting(boolean bool) {
        this.enableRuminerPainting = bool;
    }

    public boolean isEnablePhylogenesisPainting() {
        return this.enablePhylogenesisPainting;
    }

    public void setEnablePhylogenesisPainting(boolean bool) {
        this.enablePhylogenesisPainting = bool;
    }

    public boolean isEnableEscaladePainting() {
        return this.enableEscaladePainting;
    }

    public void setEnableEscaladePainting(boolean bool) {
        this.enableEscaladePainting = bool;
    }

    public boolean isEnableAquaculturePainting() {
        return this.enableAquaculturePainting;
    }

    public void setEnableAquaculturePainting(boolean bool) {
        this.enableAquaculturePainting = bool;
    }

    public boolean isEnableUnpleasantTilesPainting() {
        return this.enableUnpleasantTilesPainting;
    }

    public void setEnableUnpleasantTilesPainting(boolean bool) {
        this.enableUnpleasantTilesPainting = bool;
    }

    public boolean isGenerateWildWheat() {
        return this.generateWildWheat;
    }

    public void setGenerateWildWheat(boolean bool) {
        this.generateWildWheat = bool;
    }

    public boolean isGenerateWildCarrots() {
        return this.generateWildCarrots;
    }

    public void setGenerateWildCarrots(boolean bool) {
        this.generateWildCarrots = bool;
    }

    public boolean isGenerateWildPotatoes() {
        return this.generateWildPotatoes;
    }

    public void setGenerateWildPotatoes(boolean bool) {
        this.generateWildPotatoes = bool;
    }

    public boolean isGenerateWildBeetroot() {
        return this.generateWildBeetroot;
    }

    public void setGenerateWildBeetroot(boolean bool) {
        this.generateWildBeetroot = bool;
    }

    public boolean isGenerateAppleTrees() {
        return this.generateAppleTrees;
    }

    public void setGenerateAppleTrees(boolean bool) {
        this.generateAppleTrees = bool;
    }

    public boolean isGenerateOrangeTrees() {
        return this.generateOrangeTrees;
    }

    public void setGenerateOrangeTrees(boolean bool) {
        this.generateOrangeTrees = bool;
    }

    public boolean isGenerateLemonTrees() {
        return this.generateLemonTrees;
    }

    public void setGenerateLemonTrees(boolean bool) {
        this.generateLemonTrees = bool;
    }

    public boolean isGeneratePlumTrees() {
        return this.generatePlumTrees;
    }

    public void setGeneratePlumTrees(boolean bool) {
        this.generatePlumTrees = bool;
    }

    public boolean isGenerateAllFruitTreesInFlowerForest() {
        return this.generateAllFruitTreesInFlowerForest;
    }

    public void setGenerateAllFruitTreesInFlowerForest(boolean bool) {
        this.generateAllFruitTreesInFlowerForest = bool;
    }

    public boolean isGenerateForestTeaShrubs() {
        return this.generateForestTeaShrubs;
    }

    public void setGenerateForestTeaShrubs(boolean bool) {
        this.generateForestTeaShrubs = bool;
    }

    public boolean isGenerateForestWalnutTrees() {
        return this.generateForestWalnutTrees;
    }

    public void setGenerateForestWalnutTrees(boolean bool) {
        this.generateForestWalnutTrees = bool;
    }

    public int getFermentationTime() {
        return this.fermentationTime;
    }

    public void setFermentationTime(int value) {
        this.fermentationTime = BountifulFaresConfiguration.limit(1, 600, value);
    }

    public int getMillingTime() {
        return this.millingTime;
    }

    public void setMillingTime(int value) {
        this.millingTime = BountifulFaresConfiguration.limit(1, 10, value);
    }

    public boolean isHoneysuckleToBananaDye() {
        return this.honeysuckleToBananaDye;
    }

    public void setHoneysuckleToBananaDye(boolean bool) {
        this.honeysuckleToBananaDye = bool;
    }

    public boolean isRenameItemsToMatchDyes() {
        return this.renameItemsToMatchDyes;
    }

    public void setRenameItemsToMatchDyes(boolean bool) {
        this.renameItemsToMatchDyes = bool;
    }

    public boolean isHoneysuckleToAmberDye() {
        return this.honeysuckleToAmberDye;
    }

    public void setHoneysuckleToAmberDye(boolean bool) {
        this.honeysuckleToAmberDye = bool;
    }

    public boolean isChamomileToBeigeDye() {
        return this.chamomileToBeigeDye;
    }

    public void setChamomileToBeigeDye(boolean bool) {
        this.chamomileToBeigeDye = bool;
    }

    private static double limit(double min, double max, double value) {
        if (value > max) {
            return max;
        }
        return Math.max(value, min);
    }

    private static int limit(int min, int max, int value) {
        if (value > max) {
            return max;
        }
        return Math.max(value, min);
    }
}

